/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsutility.modules.teleporter.blocks;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mcjty.lib.api.container.DefaultContainerProvider;
import mcjty.lib.api.infusable.DefaultInfusable;
import mcjty.lib.api.infusable.IInfusable;
import mcjty.lib.bindings.GuiValue;
import mcjty.lib.blockcommands.Command;
import mcjty.lib.blockcommands.ListCommand;
import mcjty.lib.blockcommands.ServerCommand;
import mcjty.lib.tileentity.Cap;
import mcjty.lib.tileentity.CapType;
import mcjty.lib.tileentity.GenericEnergyStorage;
import mcjty.lib.tileentity.GenericTileEntity;
import mcjty.lib.tileentity.TickingTileEntity;
import mcjty.lib.typed.Key;
import mcjty.lib.typed.Type;
import mcjty.lib.varia.BlockPosTools;
import mcjty.lib.varia.Cached;
import mcjty.lib.varia.LevelTools;
import mcjty.lib.varia.Logging;
import mcjty.rftoolsbase.api.machineinfo.CapabilityMachineInformation;
import mcjty.rftoolsbase.api.machineinfo.IMachineInformation;
import mcjty.rftoolsutility.compat.RFToolsDimCompat;
import mcjty.rftoolsutility.modules.teleporter.TeleportConfiguration;
import mcjty.rftoolsutility.modules.teleporter.TeleportationTools;
import mcjty.rftoolsutility.modules.teleporter.TeleporterModule;
import mcjty.rftoolsutility.modules.teleporter.blocks.DialingDeviceTileEntity;
import mcjty.rftoolsutility.modules.teleporter.blocks.MatterReceiverTileEntity;
import mcjty.rftoolsutility.modules.teleporter.client.GuiMatterTransmitter;
import mcjty.rftoolsutility.modules.teleporter.data.TeleportDestination;
import mcjty.rftoolsutility.modules.teleporter.data.TeleportDestinations;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.GlobalPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.server.ServerLifecycleHooks;

public class MatterTransmitterTileEntity
extends TickingTileEntity {
    private TeleportDestination teleportDestination = null;
    private Integer teleportId = null;
    private boolean once = false;
    private final Set<String> allowedPlayers = new HashSet<String>();
    private int status = 0;
    private UUID teleportingPlayer = null;
    private int teleportTimer = 0;
    private int cooldownTimer = 0;
    private int totalTicks;
    private int goodTicks;
    private int badTicks;
    private int rfPerTick = 0;
    private int checkReceiverStatusCounter = 20;
    private final Cached<AABB> beamBox = Cached.of(this::createBeamBox);
    @Cap(type=CapType.ENERGY)
    private final GenericEnergyStorage energyStorage = new GenericEnergyStorage((GenericTileEntity)this, true, (long)((Integer)TeleportConfiguration.TRANSMITTER_MAXENERGY.get()).intValue(), (long)((Integer)TeleportConfiguration.TRANSMITTER_RECEIVEPERTICK.get()).intValue());
    @Cap(type=CapType.CONTAINER)
    private final LazyOptional<MenuProvider> screenHandler = LazyOptional.of(() -> new DefaultContainerProvider("Matter Transmitter").containerSupplier(DefaultContainerProvider.empty(TeleporterModule.CONTAINER_MATTER_TRANSMITTER, (GenericTileEntity)this)).energyHandler(() -> this.energyStorage).setupSync((GenericTileEntity)this));
    @Cap(type=CapType.INFUSABLE)
    private final LazyOptional<IInfusable> infusableHandler = LazyOptional.of(() -> new DefaultInfusable((BlockEntity)this));
    private final LazyOptional<IMachineInformation> infoHandler = LazyOptional.of(this::createMachineInfo);
    @GuiValue
    private String name = null;
    @GuiValue(name="private")
    private boolean privateAccess = false;
    @GuiValue(name="beam")
    private boolean beamHidden = false;
    public static final Key<String> PARAM_PLAYER = new Key("player", Type.STRING);
    @ServerCommand
    public static final Command<?> CMD_ADDPLAYER = Command.create((String)"receiver.addPlayer", (te, player, params) -> te.addPlayer((String)params.get(PARAM_PLAYER)));
    @ServerCommand
    public static final Command<?> CMD_DELPLAYER = Command.create((String)"receiver.delPlayer", (te, player, params) -> te.delPlayer((String)params.get(PARAM_PLAYER)));
    @ServerCommand(type=String.class)
    public static final ListCommand<?, ?> CMD_GETPLAYERS = ListCommand.create((String)"rftoolsutility.transmitter.getPlayers", (te, player, params) -> te.getAllowedPlayers(), (te, player, params, list) -> GuiMatterTransmitter.storeAllowedPlayersForClient(list));

    public MatterTransmitterTileEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)TeleporterModule.TYPE_MATTER_TRANSMITTER.get(), pos, state);
    }

    public String getName() {
        return this.name == null ? "" : this.name;
    }

    public void setName(String name) {
        this.name = name;
        this.m_6596_();
    }

    public boolean isPrivateAccess() {
        return this.privateAccess;
    }

    public void setPrivateAccess(boolean privateAccess) {
        this.privateAccess = privateAccess;
        this.m_6596_();
    }

    public boolean isBeamHidden() {
        return this.beamHidden;
    }

    public void setBeamHidden(boolean b) {
        this.beamHidden = b;
        this.m_6596_();
    }

    public boolean isOnce() {
        return this.once;
    }

    public boolean checkAccess(String player) {
        if (!this.privateAccess) {
            return true;
        }
        return this.allowedPlayers.contains(player);
    }

    public boolean checkAccess(UUID player) {
        if (!this.privateAccess) {
            return true;
        }
        ServerPlayer entity = ServerLifecycleHooks.getCurrentServer().m_6846_().m_11259_(player);
        if (entity == null) {
            return false;
        }
        return this.allowedPlayers.contains(entity.m_5446_().getString());
    }

    public int getStatus() {
        return this.status;
    }

    public List<String> getAllowedPlayers() {
        return new ArrayList<String>(this.allowedPlayers);
    }

    public void addPlayer(String player) {
        if (!this.allowedPlayers.contains(player)) {
            this.allowedPlayers.add(player);
            this.m_6596_();
        }
    }

    public void delPlayer(String player) {
        if (this.allowedPlayers.contains(player)) {
            this.allowedPlayers.remove(player);
            this.m_6596_();
        }
    }

    public void saveClientDataToNBT(CompoundTag tagCompound) {
        BlockPos c;
        CompoundTag info = this.getOrCreateInfo(tagCompound);
        if (this.teleportDestination != null && (c = this.teleportDestination.getCoordinate()) != null) {
            BlockPosTools.write((CompoundTag)info, (String)"dest", (BlockPos)c);
            info.m_128359_("dim", this.teleportDestination.getDimension().m_135782_().toString());
        }
        if (this.teleportId != null) {
            info.m_128405_("destId", this.teleportId.intValue());
        }
        info.m_128379_("hideBeam", this.beamHidden);
        tagCompound.m_128405_("status", this.status);
    }

    public void loadClientDataFromNBT(CompoundTag tagCompound) {
        CompoundTag info = tagCompound.m_128469_("Info");
        BlockPos c = BlockPosTools.read((CompoundTag)info, (String)"dest");
        if (c == null) {
            this.teleportDestination = null;
        } else {
            String dim = info.m_128461_("dim");
            this.teleportDestination = new TeleportDestination(c, (ResourceKey<Level>)LevelTools.getId((String)dim));
        }
        this.teleportId = info.m_128441_("destId") ? Integer.valueOf(info.m_128451_("destId")) : null;
        this.beamHidden = info.m_128471_("hideBeam");
        this.status = tagCompound.m_128451_("status");
    }

    public void m_142466_(CompoundTag tagCompound) {
        super.m_142466_(tagCompound);
        this.teleportTimer = tagCompound.m_128451_("tpTimer");
        this.cooldownTimer = tagCompound.m_128451_("cooldownTimer");
        this.totalTicks = tagCompound.m_128451_("totalTicks");
        this.goodTicks = tagCompound.m_128451_("goodTicks");
        this.badTicks = tagCompound.m_128451_("badTicks");
        this.teleportingPlayer = tagCompound.m_128403_("tpPlayer") ? tagCompound.m_128342_("tpPlayer") : null;
        this.status = tagCompound.m_128451_("status");
        this.rfPerTick = tagCompound.m_128451_("rfPerTick");
    }

    protected void loadInfo(CompoundTag tagCompound) {
        super.loadInfo(tagCompound);
        this.loadClientDataFromNBT(tagCompound);
        CompoundTag info = tagCompound.m_128469_("Info");
        this.name = info.m_128461_("tpName");
        this.privateAccess = info.m_128471_("private");
        this.once = info.m_128471_("once");
        this.allowedPlayers.clear();
        ListTag playerList = info.m_128437_("players", 8);
        for (int i = 0; i < playerList.size(); ++i) {
            String player = playerList.m_128778_(i);
            this.allowedPlayers.add(player);
        }
    }

    public void m_183515_(@Nonnull CompoundTag tagCompound) {
        super.m_183515_(tagCompound);
        tagCompound.m_128405_("tpTimer", this.teleportTimer);
        tagCompound.m_128405_("cooldownTimer", this.cooldownTimer);
        tagCompound.m_128405_("totalTicks", this.totalTicks);
        tagCompound.m_128405_("goodTicks", this.goodTicks);
        tagCompound.m_128405_("badTicks", this.badTicks);
        if (this.teleportingPlayer != null) {
            tagCompound.m_128362_("tpPlayer", this.teleportingPlayer);
        }
        tagCompound.m_128405_("status", this.status);
        tagCompound.m_128405_("rfPerTick", this.rfPerTick);
    }

    protected void saveInfo(CompoundTag tagCompound) {
        super.saveInfo(tagCompound);
        CompoundTag info = this.getOrCreateInfo(tagCompound);
        if (this.name != null && !this.name.isEmpty()) {
            info.m_128359_("tpName", this.name);
        }
        this.saveClientDataToNBT(tagCompound);
        info.m_128379_("private", this.privateAccess);
        info.m_128379_("once", this.once);
        ListTag playerTagList = new ListTag();
        for (String player : this.allowedPlayers) {
            playerTagList.add((Object)StringTag.m_129297_((String)player));
        }
        info.m_128365_("players", (Tag)playerTagList);
    }

    public boolean isDialed() {
        return this.teleportId != null || this.teleportDestination != null;
    }

    public Integer getTeleportId() {
        if (this.isDialed() && this.teleportId == null) {
            this.getTeleportDestination();
        }
        return this.teleportId;
    }

    public TeleportDestination getTeleportDestination() {
        if (this.teleportId != null) {
            TeleportDestinations teleportDestinations = TeleportDestinations.get(this.f_58857_);
            GlobalPos gc = teleportDestinations.getCoordinateForId(this.teleportId);
            if (gc == null) {
                return null;
            }
            return teleportDestinations.getDestination(gc.m_122646_(), (ResourceKey<Level>)gc.m_122640_());
        }
        return this.teleportDestination;
    }

    public void setTeleportDestination(TeleportDestination teleportDestination, boolean once) {
        this.teleportDestination = null;
        this.teleportId = null;
        this.once = once;
        if (teleportDestination != null) {
            TeleportDestinations destinations = TeleportDestinations.get(this.f_58857_);
            Integer id = destinations.getIdForCoordinate(GlobalPos.m_122643_(teleportDestination.getDimension(), (BlockPos)teleportDestination.getCoordinate()));
            if (id == null) {
                this.teleportDestination = teleportDestination;
            } else {
                this.teleportId = id;
            }
        }
        this.markDirtyClient();
    }

    private void consumeIdlePower() {
        if ((Integer)TeleportConfiguration.rfMatterIdleTick.get() > 0 && this.teleportingPlayer == null) {
            if (this.energyStorage.getEnergyStored() >= (Integer)TeleportConfiguration.rfMatterIdleTick.get()) {
                this.energyStorage.consumeEnergy((long)((Integer)TeleportConfiguration.rfMatterIdleTick.get()).intValue());
            } else {
                this.setTeleportDestination(null, false);
            }
        }
    }

    protected void tickServer() {
        if (this.isDialed()) {
            this.consumeIdlePower();
            --this.checkReceiverStatusCounter;
            if (this.checkReceiverStatusCounter <= 0) {
                this.checkReceiverStatusCounter = 20;
                int newstatus = DialingDeviceTileEntity.isDestinationAnalyzerAvailable(this.f_58857_, this.m_58899_()) ? this.checkReceiverStatus() : 0;
                if (newstatus != this.status) {
                    this.status = newstatus;
                    this.markDirtyClient();
                }
            }
        }
        if (this.isCoolingDown()) {
            return;
        }
        if (this.teleportingPlayer == null) {
            if (this.isDestinationValid()) {
                this.searchForNearestPlayer();
            }
        } else if (this.teleportDestination == null && this.teleportId == null) {
            ServerPlayer player = this.f_58857_.m_142572_().m_6846_().m_11259_(this.teleportingPlayer);
            if (player != null) {
                Logging.warn((Player)player, (String)"The destination vanished! Aborting.");
            }
            this.clearTeleport(80);
        } else if (this.isPlayerOutsideBeam()) {
            this.clearTeleport(80);
        } else {
            int rf = this.rfPerTick;
            if (this.energyStorage.getEnergyStored() < rf) {
                this.handleEnergyShortage();
            } else {
                this.m_6596_();
                this.energyStorage.consumeEnergy((long)rf);
                ++this.goodTicks;
                --this.teleportTimer;
                if (this.teleportTimer <= 0) {
                    this.performTeleport();
                }
            }
        }
    }

    private int checkReceiverStatus() {
        BlockEntity tileEntity;
        BlockPos c;
        boolean exists;
        TeleportDestination destination = this.getTeleportDestination();
        if (destination == null) {
            return 1;
        }
        ResourceKey<Level> dimension = destination.getDimension();
        int powerPercentage = RFToolsDimCompat.getPowerPercentage(this.f_58857_, dimension.m_135782_());
        if (powerPercentage >= 0 && powerPercentage < (Integer)TeleportConfiguration.DIMENSION_WARN_PERCENTAGE.get()) {
            return 1;
        }
        ServerLevel w = LevelTools.getLevel((Level)this.f_58857_, dimension);
        if (w == null) {
            if ((Integer)TeleportConfiguration.matterTransmitterLoadWorld.get() == -1) {
                return 2;
            }
            w = LevelTools.getLevel(dimension);
            this.checkReceiverStatusCounter = (Integer)TeleportConfiguration.matterTransmitterLoadWorld.get();
        }
        if (!(exists = LevelTools.isLoaded((Level)w, (BlockPos)(c = destination.getCoordinate())))) {
            if ((Integer)TeleportConfiguration.matterTransmitterLoadChunk.get() == -1) {
                return 2;
            }
            this.checkReceiverStatusCounter = (Integer)TeleportConfiguration.matterTransmitterLoadChunk.get();
        }
        if (!((tileEntity = w.m_7702_(c)) instanceof MatterReceiverTileEntity)) {
            return 1;
        }
        MatterReceiverTileEntity receiver = (MatterReceiverTileEntity)tileEntity;
        int status = receiver.checkStatus();
        return status == 0 ? 0 : 1;
    }

    private void clearTeleport(int cooldown) {
        this.m_6596_();
        TeleportationTools.applyBadEffectIfNeeded((Player)this.f_58857_.m_142572_().m_6846_().m_11259_(this.teleportingPlayer), 0, this.badTicks, this.totalTicks, false);
        this.cooldownTimer = cooldown;
        this.teleportingPlayer = null;
    }

    private boolean isDestinationValid() {
        return this.teleportId != null || this.teleportDestination != null && this.teleportDestination.isValid();
    }

    private boolean isCoolingDown() {
        this.m_6596_();
        --this.cooldownTimer;
        if (this.cooldownTimer > 0) {
            return true;
        }
        this.cooldownTimer = 0;
        return false;
    }

    private AABB createBeamBox() {
        int xCoord = this.m_58899_().m_123341_();
        int yCoord = this.m_58899_().m_123342_();
        int zCoord = this.m_58899_().m_123343_();
        return new AABB((double)xCoord, (double)(yCoord + 1), (double)zCoord, (double)(xCoord + 1), (double)(yCoord + 3), (double)(zCoord + 1));
    }

    private void searchForNearestPlayer() {
        List l = this.f_58857_.m_45976_(Player.class, (AABB)this.beamBox.get());
        Entity nearestPlayer = this.findNearestPlayer(l);
        if (nearestPlayer == null) {
            this.cooldownTimer = 5;
            return;
        }
        AABB playerBB = nearestPlayer.m_142469_();
        if (playerBB.m_82381_((AABB)this.beamBox.get())) {
            this.startTeleportation(nearestPlayer);
        } else {
            this.cooldownTimer = 5;
        }
    }

    private Entity findNearestPlayer(List<Player> l) {
        Entity nearestPlayer = null;
        double dmax = Double.MAX_VALUE;
        for (Entity entity : l) {
            double d1;
            Player player;
            if (!(entity instanceof Player) || (player = (Player)entity).m_20159_() || player.m_20160_() || this.isPrivateAccess() && !this.allowedPlayers.contains(player.m_5446_().getString()) || !((d1 = entity.m_20275_((double)this.m_58899_().m_123341_() + 0.5, (double)this.m_58899_().m_123342_() + 1.5, (double)this.m_58899_().m_123343_() + 0.5)) <= dmax)) continue;
            nearestPlayer = entity;
            dmax = d1;
        }
        return nearestPlayer;
    }

    private void performTeleport() {
        boolean boostNeeded;
        ServerPlayer player;
        boolean boosted;
        if (!this.isDestinationStillValid()) {
            ServerPlayer player2 = this.f_58857_.m_142572_().m_6846_().m_11259_(this.teleportingPlayer);
            if (player2 != null) {
                TeleportationTools.applyBadEffectIfNeeded((Player)player2, 10, this.badTicks, this.totalTicks, false);
                Logging.warn((Player)player2, (String)"Missing destination!");
            }
            this.clearTeleport(200);
            return;
        }
        TeleportDestination dest = this.getTeleportDestination();
        if (this.once) {
            this.setTeleportDestination(null, false);
        }
        if ((boosted = DialingDeviceTileEntity.isMatterBoosterAvailable(this.f_58857_, this.m_58899_())) && this.energyStorage.getEnergyStored() < (Integer)TeleportConfiguration.rfBoostedTeleport.get()) {
            boosted = false;
        }
        if ((player = this.f_58857_.m_142572_().m_6846_().m_11259_(this.teleportingPlayer)) != null && (boostNeeded = TeleportationTools.performTeleport((Player)player, dest, this.badTicks, this.totalTicks, boosted))) {
            this.energyStorage.consumeEnergy((long)((Integer)TeleportConfiguration.rfBoostedTeleport.get()).intValue());
        }
        this.teleportingPlayer = null;
    }

    private boolean isDestinationStillValid() {
        TeleportDestination dest = this.getTeleportDestination();
        return TeleportDestinations.get(this.f_58857_).isDestinationValid(dest);
    }

    private void handleEnergyShortage() {
        this.m_6596_();
        ++this.badTicks;
        if (TeleportationTools.mustInterrupt(this.badTicks, this.totalTicks)) {
            ServerPlayer player = this.f_58857_.m_142572_().m_6846_().m_11259_(this.teleportingPlayer);
            if (player != null) {
                Logging.warn((Player)player, (String)"Power failure during transit!");
            }
            this.clearTeleport(200);
        }
    }

    private boolean isPlayerOutsideBeam() {
        ServerPlayer player = this.f_58857_.m_142572_().m_6846_().m_11259_(this.teleportingPlayer);
        if (player == null) {
            return true;
        }
        AABB playerBB = player.m_142469_();
        if (!playerBB.m_82381_((AABB)this.beamBox.get())) {
            Logging.message((Player)player, (String)"Teleportation was interrupted!");
            return true;
        }
        return false;
    }

    public void startTeleportation(Entity entity) {
        if (this.cooldownTimer > 0) {
            return;
        }
        if (this.teleportingPlayer != null) {
            return;
        }
        if (!(entity instanceof Player)) {
            return;
        }
        Player player = (Player)entity;
        if (player.m_20159_() || player.m_20160_()) {
            this.cooldownTimer = 80;
            return;
        }
        TeleportDestination dest = this.teleportDestination;
        if (this.teleportId != null) {
            dest = this.getTeleportDestination();
        }
        if (dest != null && dest.isValid()) {
            ResourceKey<Level> dstId;
            int defaultCost = TeleportationTools.calculateRFCost(this.f_58857_, this.m_58899_(), dest);
            int cost = this.infusableHandler.map(inf -> (int)((float)defaultCost * (4.0f - inf.getInfusedFactor()) / 4.0f)).orElse(defaultCost);
            if (this.energyStorage.getEnergyStored() < cost) {
                Logging.warn((Player)player, (String)"Not enough power to start the teleport!");
                this.cooldownTimer = 80;
                return;
            }
            ResourceKey srcId = this.f_58857_.m_46472_();
            if (!TeleportationTools.checkValidTeleport(player, (ResourceKey<Level>)srcId, dstId = dest.getDimension())) {
                this.cooldownTimer = 80;
                return;
            }
            Logging.message((Player)player, (String)"Start teleportation...");
            this.teleportingPlayer = player.m_142081_();
            int defaultTeleportTimer = TeleportationTools.calculateTime(this.f_58857_, this.m_58899_(), dest);
            int teleportTimer = this.infusableHandler.map(inf -> (int)((float)defaultTeleportTimer * (1.2f - inf.getInfusedFactor()) / 1.2f)).orElse(defaultTeleportTimer);
            int defaultRf = (Integer)TeleportConfiguration.rfTeleportPerTick.get();
            int rf = this.infusableHandler.map(inf -> (int)((float)defaultRf * (4.0f - inf.getInfusedFactor()) / 4.0f)).orElse(defaultRf);
            int totalRfUsed = cost + rf * (teleportTimer + 1);
            this.rfPerTick = totalRfUsed / (teleportTimer + 1);
            this.totalTicks = teleportTimer;
            this.goodTicks = 0;
            this.badTicks = 0;
        } else {
            Logging.warn((Player)player, (String)"Something is wrong with the destination!");
        }
    }

    public AABB getRenderBoundingBox() {
        return new AABB(this.m_58899_(), this.m_58899_().m_142082_(1, 4, 1));
    }

    @Nonnull
    private IMachineInformation createMachineInfo() {
        return new IMachineInformation(){
            private final String[] TAGS = new String[]{"dim", "coord", "name"};
            private final String[] TAG_DESCRIPTIONS = new String[]{"The dimension this transmitter is dialed too", "The coordinate this transmitter is dialed too", "The name of the destination"};

            public int getTagCount() {
                return this.TAGS.length;
            }

            public String getTagName(int index) {
                return this.TAGS[index];
            }

            public String getTagDescription(int index) {
                return this.TAG_DESCRIPTIONS[index];
            }

            public String getData(int index, long millis) {
                TeleportDestination destination = MatterTransmitterTileEntity.this.getTeleportDestination();
                if (destination == null) {
                    return "<not dialed>";
                }
                return switch (index) {
                    case 0 -> destination.getDimension().m_135782_().toString();
                    case 1 -> destination.getCoordinate().toString();
                    case 2 -> destination.getName();
                    default -> null;
                };
            }
        };
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction facing) {
        if (cap == CapabilityMachineInformation.MACHINE_INFORMATION_CAPABILITY) {
            return this.infoHandler.cast();
        }
        return super.getCapability(cap, facing);
    }
}

